"%#%" <- function(e1,e2){
    description(e1) <- e2
    return(e1)
}


"%##%" <- function(e1,e2){
    for(n in names(e2)){
        annotation(e1)[n] <- as.character(e2[n])
    }
    return(e1)
}


"%@%" <- function(e1,e2){
    e2 <- substitute(e2)
    if(typeof(e2)=="symbol"){
        e2 <- deparse(e2)
    } else {
        e2 <- eval.parent(e2)
    }
    attr(e1,e2)
}

"%@%<-" <- function(x,nm,value){
    nm <- substitute(nm)
    if(typeof(nm)=="symbol"){
        nm <- deparse(nm)
    } else {
        nm <- eval.parent(nm)
    }
    attr(x,nm) <- value
    return(invisible(x))
}
